const AppError = require("../../utils/appError");
const conn = require("../../services/db");
const { Compare } = require("../../utils/encryption");
const {
  getAccessToken,
  getRefreshToken,
  verifyAccessToken,
} = require("../../helpers/JwtHelper");

module.exports = {
  login: (req, res, next) => {
    const { email, password } = req?.body;
    conn.query(
      "SELECT * FROM admin_users WHERE email_id = ?",
      [email],
      async function (err, result, fields) {

        if (err) return next(new AppError(err));
        if (result?.length == 0)
          next(new AppError("Please enter valid login credentials", 200));
        const row = result?.length > 0 ? result[0] || {} : {};
        if (result?.length > 0) {
          const isPasswordCorrect = await Compare(password, row?.password);
          if (isPasswordCorrect) {
            const accessToken = getAccessToken({
              email: row?.email,
            });
            // const refreshToken = getRefreshToken({
            //   email: row?.email,
            // });

            // req.session.accessToken = accessToken;
            // req.session.refreshToken = refreshToken;

            res.status(200).json({
              status: "success",
              message: "Logged in successfully.",
              data: {
                accessToken,
                // refreshToken
              },
            });
          } else {
            return next(
              new AppError("Please enter valid email id and password", 200)
            );
          }
        }
      }
    );
  },
  verify: (req, res, next) => {
    const isValid = verifyAccessToken(req);
    res.status(200).json({
      status: isValid ? "success" : false,
      authorize: isValid,
    });
  },
  logout: (req, res, next) => {
    req.session.accessToken = null;
    res.status(200).json({
      status: "success",
      message: "Logout Successfully",
    });
  },
};
