const AppError = require("../../utils/appError");
const conn = require("../../services/db").default;
const { PAGINATION_LIMIT, STATUS_TYPE } = require("../../config/AppConstant");
const DbHelper = require("../../helpers/DbHelper");
const { base64ToFile } = require("../../lib/FileManager");
const { getSlug } = require("../../helpers/Slug");

module.exports = {
  list: (req, res, next) => {
    const { title, status, limit, page } = req?.body;
    let query =
      "SELECT SQL_CALC_FOUND_ROWS title,id,status,slug, created FROM `pages`";
    let queryParams = [];
    const titleReq = title && title?.length > 0 ? title : null;
    const statusReq =
      status && status?.length > 0 && STATUS_TYPE.includes(status)
        ? status
        : null;

    if (titleReq && statusReq) {
      query = query + " WHERE `title` like ? AND `status` = ?";
      queryParams = [`%${titleReq}%`, statusReq];
    } else {
      if (titleReq) {
        query = query + " WHERE `title` like ?";
        queryParams = [`%${titleReq}%`];
      }
      if (statusReq) {
        query = query + " WHERE `status` = ?";
        queryParams = [statusReq];
      }
    }
    const recordLimit = limit || PAGINATION_LIMIT;
    const pageNo = page || 0;
    const OFFSET = pageNo * recordLimit;
    query = query + ` ORDER BY id DESC  LIMIT ?, ?`;
    queryParams.push(OFFSET);
    queryParams.push(recordLimit);

    try {
      conn.query(query, queryParams, async function (err, result, fields) {
        if (err) {
          const errorMessage =
            result?.error?.message || "Something went wrong, Please try again";
          return next(new AppError(errorMessage, 500));
        } else if (result) {
          const response = await DbHelper.promisifyQuery(
            "SELECT COUNT(*) as totalRow FROM `pages`",
            conn,
            next
          );
          const totalRows = (response.length > 0 && response[0]?.totalRow) || 0;
          res.status(200).json({
            status: "success",
            message: "CMS Listing",
            result: {
              count: totalRows,
              list: result,
            },
          });
        }
      });
    } catch (e) {
      console.log("Exception Error : Category Listing ", e);
      return next(new AppError("Something went wrong, Please try again", 500));
    }
  },
  save: async (req, res, next) => {
    const {
      title,
      description,
      status,
      meta_title,
      meta_keywords,
      meta_description,
    } = req?.body;
    const slug = getSlug(title);
    try {
      const isExist = await DbHelper.promisifyQuery(
        `SELECT id FROM \`pages\` WHERE slug = "${slug}"`,
        conn,
        next
      );
      if (isExist?.length < 1) {
        const formData = [
          title,
          slug,
          description,
          status ? "active" : "deactive",
          meta_title,
          meta_keywords,
          meta_description,
        ];
        conn.query(
          "INSERT INTO `pages` (`title`,`slug`,`description`,`status`,`meta_title`,`meta_keywords`,`meta_description`) VALUES (?,?,?,?,?,?,?)",
          formData,
          async function (err, result, fields) {
            if (err) {
              const errorMessage =
                result?.error?.message ||
                "Something went wrong, Please try again";
              return next(new AppError(errorMessage, 500));
            }

            res.status(200).json({
              status: "success",
              message: "CMS stored successfully.",
              result,
            });
          }
        );
      } else {
        res.status(200).json({
          status: "error",
          data: {
            title:
              "CMS Page with this name already exist, please provide unique name.",
          },
        });
      }
    } catch (e) {
      console.log("Exception Error : Category Creation ", e);
      return next(new AppError("Something went wrong, Please try again", 500));
    }
  },
  update: async (req, res, next) => {
    try {
      if (!req.params) return next(new AppError("No req data found", 404));
      const { id } = req.params;
      const {
        title,
        description,
        status,
        meta_title,
        meta_keywords,
        meta_description,
      } = req?.body;
      const slug = getSlug(title);
      const isExist = await DbHelper.promisifyQuery(
        `SELECT id FROM \`pages\` WHERE \`slug\` = "${slug}" AND \`id\` != ${id}`,
        conn,
        next
      );
      if (isExist?.length < 1) {
        let query =
          "UPDATE `pages` SET `title` = ? ,`slug` = ?, `description` = ?, `status` = ?, `meta_title` = ?, `meta_keywords` = ?, `meta_description` = ? WHERE `id` = ?";
        let sqlData = [
          title,
          slug,
          description,
          status ? "active" : "deactive",
          meta_title,
          meta_keywords,
          meta_description,
          id,
        ];
        conn.query(query, sqlData, async function (err, result, fields) {
          if (err) {
            const errorMessage =
              result?.error?.message ||
              "Something went wrong, Please try again";
            return next(new AppError(errorMessage, 500));
          }

          res.status(200).json({
            status: "success",
            message: "CMS successfully updated.",
            result,
          });
        });
      } else {
        res.status(200).json({
          status: "error",
          data: {
            title:
              "CMS Page with this name already exist, please provide unique name.",
          },
        });
      }
    } catch (e) {
      console.log("Exception Error : Category Updated ", e);
      return next(new AppError("Something went wrong, Please try again", 500));
    }
  },
  view: (req, res, next) => {
    try {
      const { id } = req?.params;
      const query = "SELECT * FROM `pages`  WHERE `id` = ?";
      const sqlData = [id];
      conn.query(query, sqlData, async function (err, result, fields) {
        if (err) {
          const errorMessage =
            result?.error?.message || "Something went wrong, Please try again";
          return next(new AppError(errorMessage, 500));
        }

        res.status(200).json({
          status: "success",
          message: "CMS Information fetched",
          result: (result?.length > 0 && result[0]) || undefined,
        });
      });
    } catch (e) {
      console.log("Exception Error : CMS Fetched ", e);
      return next(new AppError("Something went wrong, Please try again", 500));
    }
  },
  delete: async (req, res, next) => {
    try {
      const { id } = req?.body;
      const isExist = await DbHelper.promisifyQuery(
        `SELECT id FROM \`pages\` WHERE \`id\` = "${id}"`,
        conn,
        next
      );
      if (isExist?.length > 0) {
        const query = "DELETE FROM `pages` WHERE `id` = ?";
        const sqlData = [id];
        conn.query(query, sqlData, async function (err, result, fields) {
          if (err) {
            const errorMessage =
              result?.error?.message ||
              "Something went wrong, Please try again";
            return next(new AppError(errorMessage, 500));
          }

          res.status(200).json({
            status: "success",
            message: "CMS removed successfully.",
            result: (result?.length > 0 && result[0]) || undefined,
          });
        });
      } else {
        res.status(200).json({
          status: "error",
          message: "You are trying to remove a wrong CMS Page",
        });
      }
    } catch (e) {
      console.log("Exception Error : Category Removal ", e);
      return next(new AppError("Something went wrong, Please try again", 500));
    }
  },
};
