const AppError = require("../../utils/appError");
module.exports = {
    upload: async (req, res, next) => {
        try {
            const { file, dir } = req?.body;
            let { path } = await base64ToFile(file, dir);
            if (path) {
                res.status(200).json({
                    message: "File uploaded successfully",
                    result: {
                        path,
                    },
                });
            } else {
                return next(
                    new AppError("Something went wrong, Please try again", 500)
                );
            }
        } catch (e) {
            console.log("Exception Error : Category Creation ", e);
            return next(
                new AppError("Something went wrong, Please try again", 500)
            );
        }
    },
};
