const AppError = require("../../utils/appError");
const conn = require("../../services/db").default;
const { PAGINATION_LIMIT } = require("../../config/AppConstant");
const DbHelper = require("../../helpers/DbHelper");
const { base64ToFile } = require("../../lib/FileManager");

module.exports = {
  list: async (req, res, next) => {
    const { title, limit, page } = req?.body;
    let query =
      "SELECT SQL_CALC_FOUND_ROWS id, `key`, created FROM `firebase_keys`";
    let queryParams = [];
    const titleReq = title && title?.length > 0 ? title : null;
    if (titleReq) {
      query = query + " WHERE `key` like ? ";
      queryParams = [`%${titleReq}%`];
    }

    const recordLimit = limit || PAGINATION_LIMIT;
    const pageNo = page || 0;

    const OFFSET = pageNo * recordLimit;
    query = query + ` ORDER BY id DESC  LIMIT ?, ?`;
    queryParams.push(OFFSET);
    queryParams.push(recordLimit);

    try {
      conn.query(query, queryParams, async function (err, result, fields) {
        if (err) {
          const errorMessage =
            result?.error?.message || "Something went wrong, Please try again";
          return next(new AppError(errorMessage, 500));
        } else if (result) {
          const response = await DbHelper.promisifyQuery(
            "SELECT COUNT(*) as totalRow FROM `firebase_keys`",
            conn,
            next
          );
          const totalRows = (response.length > 0 && response[0]?.totalRow) || 0;
          res.status(200).json({
            status: "success",
            message: "Notification Token Listing",
            result: {
              count: totalRows,
              list: result,
            },
          });
        }
      });
    } catch (e) {
      console.log("Exception Error : Notification Token Listing ", e);
      return next(new AppError("Something went wrong, Please try again", 500));
    }
  },
  delete: (req, res, next) => {
    try {
      const { id } = req?.body;
      const query = "DELETE FROM `firebase_keys` WHERE `id` = ?";
      const sqlData = [id];
      conn.query(query, sqlData, async function (err, result, fields) {
        if (err) {
          const errorMessage =
            result?.error?.message || "Something went wrong, Please try again";
          return next(new AppError(errorMessage, 500));
        }

        res.status(200).json({
          status: "success",
          message: "Notification Token removed successfully.",
          result: (result?.length > 0 && result[0]) || undefined,
        });
      });
    } catch (e) {
      console.log("Exception Error : Notification Token Removal ", e);
      return next(new AppError("Something went wrong, Please try again", 500));
    }
  },
};
