const AppError = require("../../utils/appError");
const conn = require("../../services/db").default;
const { PAGINATION_LIMIT } = require("../../config/AppConstant");
const DbHelper = require("../../helpers/DbHelper");

module.exports = {
  list: (req, res, next) => {
    const { title, limit, page } = req?.body;
    let query =
      "SELECT SQL_CALC_FOUND_ROWS id,email, created FROM `subscriptions`";
    let queryParams = [];
    const titleReq = title && title?.length > 0 ? title : null;
    if (titleReq) {
      query = query + " WHERE `email` like ? ";
      queryParams = [`%${titleReq}%`];
    }

    const recordLimit = limit || PAGINATION_LIMIT;
    const pageNo = page || 0;

    const OFFSET = pageNo * recordLimit;
    query = query + ` ORDER BY id DESC  LIMIT ?, ?`;
    queryParams.push(OFFSET);
    queryParams.push(recordLimit);
    try {
      conn.query(query, queryParams, async function (err, result, fields) {
        if (err) {
          const errorMessage =
            result?.error?.message || "Something went wrong, Please try again";
          return next(new AppError(errorMessage, 500));
        } else if (result) {
          const response = await DbHelper.promisifyQuery(
            "SELECT COUNT(*) as totalRow FROM `subscriptions`",
            conn,
            next
          );
          const totalRows = (response.length > 0 && response[0]?.totalRow) || 0;
          res.status(200).json({
            status: "success",
            message: "Subscription Listing",
            result: {
              count: totalRows,
              list: result,
            },
          });
        }
      });
    } catch (e) {
      console.log("Exception Error : Subscription Listing ", e);
      return next(new AppError("Something went wrong, Please try again", 500));
    }
  },
  save: async (req, res, next) => {
    const { email } = req?.body;
    try {
      const response = await DbHelper.promisifyQuery(
        `SELECT * FROM \`subscriptions\` WHERE email = '${email}' `,
        conn,
        next
      );
      const isExist = response && response.length > 0 ? response[0] : null;
      if (!isExist) {
        conn.query(
          "INSERT INTO `subscriptions` (`email`) VALUES (?)",
          [email],
          async function (err, result, fields) {
            console.log("ERROR ", err);
            if (err) {
              const errorMessage =
                result?.error?.message ||
                "Something went wrong, Please try again";
              return next(new AppError(errorMessage, 500));
            }
            res.status(200).json({
              status: "success",
              message: "Subscriber Added successfully.",
              result,
            });
          }
        );
      } else {
        res.status(200).json({
          status: "error",
          message: "Subscriber already exist with same email address.",
        });
      }
    } catch (e) {
      console.log("Exception Error : Subscriber Creation ", e);
      return next(new AppError("Something went wrong, Please try again", 500));
    }
  },
  update: async (req, res, next) => {
    try {
      if (!req.params) return next(new AppError("No req data found", 404));
      const { email } = req?.body;
      const { id } = req?.params;
      const response = await DbHelper.promisifyQuery(
        `SELECT * FROM subscriptions WHERE email = "${email}" AND id != ${id}`,
        conn,
        next
      );
      const isExist = response && response.length > 0 ? response[0] : null;
      if (!isExist) {
        conn.query(
          "UPDATE `subscriptions` SET `email` = ? WHERE `id` = ?",
          [email, id],
          async function (err, result, fields) {
            if (err) {
              const errorMessage =
                result?.error?.message ||
                "Something went wrong, Please try again";
              return next(new AppError(errorMessage, 500));
            }

            res.status(200).json({
              status: "success",
              message: "Subscriber successfully updated.",
              result,
            });
          }
        );
      } else {
        res.status(200).json({
          status: "error",
          message: "Subscriber already exist with same email address.",
        });
      }
    } catch (e) {
      console.log("Exception Error : Subscriber Updated ", e);
      return next(new AppError("Something went wrong, Please try again", 500));
    }
  },
  view: (req, res, next) => {
    try {
      if (!req.params) return next(new AppError("No req data found", 404));
      const { id } = req.params;
      const query = "SELECT * FROM `subscriptions` WHERE id = ?";
      const sqlData = [id];
      conn.query(query, sqlData, async function (err, result, fields) {
        if (err) {
          const errorMessage =
            result?.error?.message || "Something went wrong, Please try again";
          return next(new AppError(errorMessage, 500));
        }

        res.status(200).json({
          status: "success",
          message: "Subscriber Information fetched",
          result: (result?.length > 0 && result[0]) || undefined,
        });
      });
    } catch (e) {
      console.log("Exception Error : Subscriber Fetched ", e);
      return next(new AppError("Something went wrong, Please try again", 500));
    }
  },
  delete: (req, res, next) => {
    try {
      const { id } = req?.body;
      const query = "DELETE FROM `subscriptions` WHERE `id` = ?";
      const sqlData = [id];
      conn.query(query, sqlData, async function (err, result, fields) {
        if (err) {
          const errorMessage =
            result?.error?.message || "Something went wrong, Please try again";
          return next(new AppError(errorMessage, 500));
        }

        res.status(200).json({
          status: "success",
          message: "Subscriber removed successfully.",
          result: (result?.length > 0 && result[0]) || undefined,
        });
      });
    } catch (e) {
      console.log("Exception Error : Subscriber Removal ", e);
      return next(new AppError("Something went wrong, Please try again", 500));
    }
  },
};
