const DbHelper = require("../../../helpers/DbHelper");
const AppError = require("../../../utils/appError");
const conn = require("../../../services/db");

async function createSubscriptionPlan(req, res, next) {
  const { name, price, description, status, duration_type, max_locations, max_staff } = req?.body;
  
  try {
    // Validate required fields
    if (!name || !price || !duration_type || max_locations === undefined || max_locations === null || max_staff === undefined || max_staff === null) {
      return res.status(200).json({
        status: "error",
        error: {
          message: "Name, price, duration type, max locations, and max staff are required fields.",
        },
      });
    }

    // Check if plan with same name exists
    const isExist = await DbHelper.promisifyQuery(
      `SELECT id FROM \`subscription_plans\` WHERE name = "${name}" AND is_deleted IS NULL`,
      conn,
      next
    );

    if (isExist?.length > 0) {
      return res.status(200).json({
        status: "error",
        error: {
          name: "Subscription plan with same name already exists, please provide a unique name.",
        },
      });
    }

    const formData = [name, price, duration_type, parseInt(max_locations) || 0, parseInt(max_staff) || 0, description || null, status || "active"];
    const query = `INSERT INTO \`subscription_plans\` (\`name\`, \`price\`, \`duration_type\`, \`max_locations\`, \`max_staff\`, \`description\`, \`status\`) VALUES (?, ?, ?, ?, ?, ?, ?)`;
    
    conn.query(query, formData, async function (err, result, fields) {
      if (err) {
        const errorMessage =
          err?.message || "Something went wrong, Please try again";
        return next(new AppError(errorMessage, 500));
      }

      res.status(200).json({
        status: "success",
        message: "Subscription plan created successfully.",
        data: {
          id: result?.insertId,
          name,
          price,
          duration_type,
          max_locations: parseInt(max_locations) || 0,
          max_staff: parseInt(max_staff) || 0,
          description,
          status: status || "active",
        },
      });
    });
  } catch (e) {
    console.log("Exception Error : Subscription Plan Creation ", e);
    return next(new AppError("Something went wrong, Please try again", 500));
  }
}

module.exports = createSubscriptionPlan;

