const DbHelper = require("../../../helpers/DbHelper");
const AppError = require("../../../utils/appError");
const conn = require("../../../services/db");

async function deleteSubscriptionPlan(req, res, next) {
  try {
    const { id } = req?.params;
    
    const isExist = await DbHelper.promisifyQuery(
      `SELECT id FROM \`subscription_plans\` WHERE \`is_deleted\` IS NULL AND \`id\` = ${id}`,
      conn,
      next
    );

    if (isExist?.length > 0) {
      const query =
        "UPDATE `subscription_plans` SET `is_deleted` = '1', `updated_at` = NOW() WHERE `id` = ?";
      const sqlData = [id];
      conn.query(query, sqlData, async function (err, result, fields) {
        if (err) {
          const errorMessage =
            err?.message || "Something went wrong, Please try again";
          return next(new AppError(errorMessage, 500));
        }

        res.status(200).json({
          status: "success",
          message: "Subscription plan deleted successfully.",
          result: (result?.length > 0 && result[0]) || undefined,
        });
      });
    } else {
      res.status(200).json({
        status: "error",
        message: "Subscription plan not found or already deleted.",
      });
    }
  } catch (e) {
    console.log("Exception Error : Subscription Plan Deletion ", e);
    return next(new AppError("Something went wrong, Please try again", 500));
  }
}

module.exports = deleteSubscriptionPlan;

