const DbHelper = require("../../../helpers/DbHelper");
const AppError = require("../../../utils/appError");
const conn = require("../../../services/db");
const { PAGINATION_LIMIT } = require("../../../config/AppConstant");

async function subscriptionPlanList(req, res, next) {
  const { name, limit, page, status } = req?.body;
  let query =
    "SELECT SQL_CALC_FOUND_ROWS id, name, price, duration_type, max_locations, max_staff, status, created_at, updated_at FROM `subscription_plans` WHERE `is_deleted` IS NULL";
  let queryParams = [];
  const nameReq = name ?? null;
  const statusReq = status ?? null;

  if (nameReq) {
    query = query + " AND `name` LIKE ?";
    queryParams.push(`%${nameReq}%`);
  }

  if (statusReq !== null && statusReq !== undefined && statusReq !== "") {
    query = query + " AND `status` = ?";
    queryParams.push(statusReq);
  }

  const recordLimit = Number(limit) ?? PAGINATION_LIMIT;
  const pageNo = page > 0 ? Number(page) - 1 : 0;

  const OFFSET = pageNo * recordLimit;
  query = query + ` ORDER BY id DESC LIMIT ?, ?`;
  queryParams.push(OFFSET);
  queryParams.push(recordLimit);

  try {
    conn.query(query, queryParams, async function (err, result, fields) {
      if (err) {
        const errorMessage =
          err?.message || "Something went wrong, Please try again";
        return next(new AppError(errorMessage, 500));
      } else if (result) {
        const response = await DbHelper.promisifyQuery(
          "SELECT FOUND_ROWS() as totalRow",
          conn,
          next
        );
        const totalRows = (response.length > 0 && response[0]?.totalRow) || 0;
        
        // Convert price from string to number (MySQL DECIMAL returns as string)
        const plans = (result || []).map(plan => ({
          ...plan,
          price: parseFloat(plan.price) || 0,
        }));
        
        res.status(200).json({
          status: "success",
          message: "Subscription Plan List",
          total_records: totalRows,
          data: plans,
        });
      }
    });
  } catch (e) {
    console.log("Exception Error : Subscription Plan Listing ", e);
    return next(new AppError("Something went wrong, Please try again", 500));
  }
}

module.exports = subscriptionPlanList;

