const AppError = require("../../../utils/appError");
const conn = require("../../../services/db");
const DbHelper = require("../../../helpers/DbHelper");

function readSubscriptionPlan(req, res, next) {
  try {
    if (!req.params) return next(new AppError("No req data found", 404));
    const { id } = req.params;
    const query =
      "SELECT id, name, price, duration_type, max_locations, max_staff, description, status, created_at, updated_at FROM `subscription_plans` WHERE `is_deleted` IS NULL AND id = ?";
    const sqlData = [id];

    conn.query(query, sqlData, async function (err, result, fields) {
      if (err) {
        const errorMessage =
          err?.message || "Something went wrong, Please try again";
        return next(new AppError(errorMessage, 500));
      }

      if (result?.length < 1) {
        return res.status(200).json({
          status: "error",
          message: "Subscription plan not found.",
        });
      }

      // Convert price from string to number (MySQL DECIMAL returns as string)
      const plan = {
        ...result[0],
        price: parseFloat(result[0].price) || 0,
      };

      res.status(200).json({
        status: "success",
        message: "Subscription plan information fetched successfully",
        data: plan,
      });
    });
  } catch (e) {
    console.log("Exception Error : Subscription Plan Fetch ", e);
    return next(new AppError("Something went wrong, Please try again", 500));
  }
}

module.exports = readSubscriptionPlan;

