const DbHelper = require("../../../helpers/DbHelper");
const AppError = require("../../../utils/appError");
const conn = require("../../../services/db");

async function updateSubscriptionPlanStatus(req, res, next) {
  try {
    if (!req.params) return next(new AppError("No req data found", 404));
    const { id } = req.params;
    const { status } = req?.body;

    if (!status || !["active", "inactive"].includes(status)) {
      return res.status(200).json({
        status: "error",
        error: {
          message: "Status must be either 'active' or 'inactive'.",
        },
      });
    }

    // Check if plan exists
    const planExists = await DbHelper.promisifyQuery(
      `SELECT id, status FROM \`subscription_plans\` WHERE \`id\` = ${id} AND is_deleted IS NULL`,
      conn,
      next
    );

    if (planExists?.length < 1) {
      return res.status(200).json({
        status: "error",
        message: "Subscription plan not found.",
      });
    }

    const query = "UPDATE `subscription_plans` SET `status` = ?, `updated_at` = NOW() WHERE `id` = ?";
    const sqlData = [status, id];

    conn.query(query, sqlData, async function (err, result, fields) {
      if (err) {
        const errorMessage =
          err?.message || "Something went wrong, Please try again";
        return next(new AppError(errorMessage, 500));
      }

      res.status(200).json({
        status: "success",
        message: `Subscription plan ${status === "active" ? "activated" : "deactivated"} successfully.`,
        data: {
          id,
          status,
        },
      });
    });
  } catch (e) {
    console.log("Exception Error : Subscription Plan Status Update ", e);
    return next(new AppError("Something went wrong, Please try again", 500));
  }
}

module.exports = updateSubscriptionPlanStatus;

