const DbHelper = require("../../../helpers/DbHelper");
const AppError = require("../../../utils/appError");
const conn = require("../../../services/db");

async function updateSubscriptionPlan(req, res, next) {
  try {
    if (!req.params) return next(new AppError("No req data found", 404));
    const { id } = req.params;
    const { name, price, description, status, duration_type, max_locations, max_staff } = req?.body;

    // Validate required fields
    if (!name || !price || !duration_type || max_locations === undefined || max_locations === null || max_staff === undefined || max_staff === null) {
      return res.status(200).json({
        status: "error",
        error: {
          message: "Name, price, duration type, max locations, and max staff are required fields.",
        },
      });
    }

    // Check if plan with same name exists (excluding current plan)
    const isExist = await DbHelper.promisifyQuery(
      `SELECT id FROM \`subscription_plans\` WHERE \`name\` = "${name}" AND \`id\` != ${id} AND is_deleted IS NULL`,
      conn,
      next
    );

    if (isExist?.length > 0) {
      return res.status(200).json({
        status: "error",
        error: {
          name: "Subscription plan with same name already exists, please provide a unique name.",
        },
      });
    }

    // Check if plan exists
    const planExists = await DbHelper.promisifyQuery(
      `SELECT id FROM \`subscription_plans\` WHERE \`id\` = ${id} AND is_deleted IS NULL`,
      conn,
      next
    );

    if (planExists?.length < 1) {
      return res.status(200).json({
        status: "error",
        message: "Subscription plan not found.",
      });
    }

    const query = "UPDATE `subscription_plans` SET `name` = ?, `price` = ?, `duration_type` = ?, `max_locations` = ?, `max_staff` = ?, `description` = ?, `status` = ?, `updated_at` = NOW() WHERE `id` = ?";
    const sqlData = [name, price, duration_type, parseInt(max_locations) || 0, parseInt(max_staff) || 0, description || null, status || "active", id];

    conn.query(query, sqlData, async function (err, result, fields) {
      if (err) {
        const errorMessage =
          err?.message || "Something went wrong, Please try again";
        return next(new AppError(errorMessage, 500));
      }

      res.status(200).json({
        status: "success",
        message: "Subscription plan updated successfully.",
        data: {
          id,
          name,
          price,
          duration_type,
          max_locations: parseInt(max_locations) || 0,
          max_staff: parseInt(max_staff) || 0,
          description,
          status: status || "active",
        },
      });
    });
  } catch (e) {
    console.log("Exception Error : Subscription Plan Update ", e);
    return next(new AppError("Something went wrong, Please try again", 500));
  }
}

module.exports = updateSubscriptionPlan;

