const DbHelper = require("../../../helpers/DbHelper");
const AppError = require("../../../utils/appError");
const conn = require("../../../services/db");

async function deleteContest(req, res, next) {
  try {
    const { id } = req?.params;
    const isExist = await DbHelper.promisifyQuery(
      `SELECT id FROM \`contests\` WHERE \`is_cancelled\` IS NULL AND \`id\` = ${id}`,
      conn,
      next
    );

    if (isExist?.length > 0) {
      const query = "UPDATE `contests` SET `is_cancelled` = '1' WHERE `id` = ?";
      const sqlData = [id];
      conn.query(query, sqlData, async function (err, result, fields) {
        if (err) {
          const errorMessage =
            result?.error?.message || "Something went wrong, Please try again";
          return next(new AppError(errorMessage, 500));
        }

        res.status(200).json({
          status: "success",
          message: "Contest removed successfully.",
          result: (result?.length > 0 && result[0]) || undefined,
        });
      });
    } else {
      res.status(200).json({
        status: "error",
        message: "You are trying to remove a wrong contest",
      });
    }
  } catch (e) {
    console.log("Exception Error : Post Removal ", e);
    return next(new AppError("Something went wrong, Please try again", 500));
  }
}

module.exports = deleteContest;
