const AppError = require("../../../utils/appError");
const conn = require("../../../services/db");
const DbHelper = require("../../../helpers/DbHelper");

function userInfo(req, res, next) {
  try {
    if (!req.params) return next(new AppError("No req data found", 404));
    const { id } = req.params;
      const query = `SELECT u.id, u.first_name, u.last_name, u.full_name, u.email, u.phone, u.shop_name, u.location, u.profile_picture, u.provider, u.created_at
      FROM users as u 
      WHERE u.is_deleted IS NULL AND u.id = ?`;
    const sqlData = [id];

    conn.query(query, sqlData, async function (err, result, fields) {
      if (err) {
        console.log("Exception caught to fetch the user info ", err);
        const errorMessage =
          result?.error?.message || "Something went wrong, Please try again";
        return next(new AppError(errorMessage, 500));
      }

      // Contest functionality removed
      let usersContest = [];

      // Fetch active subscription information
      const subscriptionQuery = `
        SELECT 
          us.id as subscription_id,
          us.plan_type,
          us.amount,
          us.start_date,
          us.end_date,
          us.status as subscription_status,
          us.created_at as subscription_created_at,
          sp.id as plan_id,
          sp.name as plan_name,
          sp.price as plan_price,
          sp.duration_type,
          sp.max_locations,
          sp.max_staff,
          sp.description as plan_description
        FROM user_subscriptions us
        LEFT JOIN subscription_plans sp ON us.subscription_plan_id = sp.id
        WHERE us.user_id = ? 
          AND us.status = 'active' 
          AND us.end_date > NOW()
        ORDER BY us.created_at DESC
        LIMIT 1
      `;

      const subscriptionResult = await DbHelper.promisifyQuery(subscriptionQuery, conn, next, [id]);

      // Convert subscription amount and plan_price from string to number (MySQL DECIMAL returns as string)
      let subscription = null;
      if (subscriptionResult && subscriptionResult.length > 0) {
        subscription = {
          ...subscriptionResult[0],
          amount: parseFloat(subscriptionResult[0].amount) || 0,
          plan_price: subscriptionResult[0].plan_price ? parseFloat(subscriptionResult[0].plan_price) || 0 : null,
        };
      }

      res.status(200).json({
        status: "success",
        message: "User Information",
        data: {
          ...result[0],
          subscription: subscription,
        },
      });
    });
  } catch (e) {
    console.log("Exception Error : Failed to fetch user info  ", e);
    return next(new AppError("Something went wrong, Please try again", 500));
  }
}

module.exports = userInfo;
