const { query } = require("./shared");
const { recalculateAttendanceHours } = require("./breakHelpers");

async function deleteBreak(req, res) {
  try {
    const { break_id } = req.params;

    // Verify break belongs to admin and get attendance_id
    const breaks = await query(
      `SELECT ws.id, ws.attendance_id
      FROM work_sessions ws
      JOIN attendance a ON ws.attendance_id = a.id
      JOIN staff s ON a.staff_id = s.id
      JOIN branches b ON s.branch_id = b.id
      JOIN shops sh ON b.shop_id = sh.id
      WHERE ws.id = ? AND sh.admin_id = ? AND ws.session_type = 'break'`,
      [break_id, req.user.id]
    );

    if (!breaks || breaks.length === 0) {
      return res
        .status(403)
        .json({ error: "Access denied or break not found" });
    }

    const attendanceId = breaks[0].attendance_id;

    await query("DELETE FROM work_sessions WHERE id = ?", [break_id]);

    // Recalculate total hours for the attendance record
    await recalculateAttendanceHours(attendanceId);

    res.json({ message: "Break deleted successfully" });
  } catch (error) {
    console.error("Delete break error:", error);
    res.status(500).json({ error: "Internal server error" });
  }
}

module.exports = deleteBreak;

