const { query } = require("./shared");

async function getAttendance(req, res) {
  try {
    const { branch_id } = req.params;
    const { start_date, end_date } = req.query;

    const branches = await query(
      `
      SELECT b.id 
      FROM branches b
      JOIN shops s ON b.shop_id = s.id
      WHERE b.id = ? AND s.admin_id = ?
    `,
      [branch_id, req.user.id]
    );

    if (!branches || branches.length === 0) {
      return res.status(403).json({ error: "Access denied to this branch" });
    }

    let attendanceQuery = `
      SELECT 
        a.*,
        s.staff_code,
        s.full_name,
        s.position
      FROM attendance a
      JOIN staff s ON a.staff_id = s.id
      WHERE a.branch_id = ?
    `;

    const params = [branch_id];

    if (start_date) {
      attendanceQuery += " AND a.attendance_date >= ?";
      params.push(start_date);
    }

    if (end_date) {
      attendanceQuery += " AND a.attendance_date <= ?";
      params.push(end_date);
    }

    attendanceQuery += " ORDER BY a.attendance_date DESC, a.clock_in_time DESC";

    const attendance = await query(attendanceQuery, params);

    res.json({ attendance });
  } catch (error) {
    res.status(500).json({ error: "Internal server error" });
  }
}

module.exports = getAttendance;

