const { query } = require("./shared");

async function getAttendanceSummary(req, res) {
  try {
    const { branch_id } = req.params;
    const { start_date, end_date } = req.query;

    const branches = await query(
      `
      SELECT b.id 
      FROM branches b
      JOIN shops s ON b.shop_id = s.id
      WHERE b.id = ? AND s.admin_id = ?
    `,
      [branch_id, req.user.id]
    );

    if (!branches || branches.length === 0) {
      return res.status(403).json({ error: "Access denied to this branch" });
    }

    const today = new Date().toISOString().split("T")[0];
    const dateCondition =
      start_date && end_date
        ? "AND a.attendance_date BETWEEN ? AND ?"
        : "AND a.attendance_date = ?";

    const dateParams =
      start_date && end_date ? [branch_id, start_date, end_date] : [branch_id, today];

    const summaryRows = await query(
      `
      SELECT 
        COUNT(DISTINCT s.id) as total_staff,
        COUNT(DISTINCT CASE WHEN a.status = 'present' THEN a.staff_id END) as present_count,
        COUNT(DISTINCT CASE WHEN a.status = 'absent' THEN a.staff_id END) as absent_count,
        AVG(a.total_hours) as avg_hours,
        SUM(a.total_hours) as total_hours
      FROM staff s
      LEFT JOIN attendance a ON s.id = a.staff_id ${dateCondition}
      WHERE s.branch_id = ? AND s.is_active = true
    `,
      dateParams
    );

    res.json({ summary: summaryRows && summaryRows.length > 0 ? summaryRows[0] : null });
  } catch (error) {
    res.status(500).json({ error: "Internal server error" });
  }
}

module.exports = getAttendanceSummary;

