const { query } = require("./shared");

async function getStaffAttendance(req, res) {
  try {
    const { staff_id } = req.params;
    const { start_date, end_date } = req.query;

    const staffRows = await query(
      `
      SELECT st.id, st.full_name, st.staff_code, b.name as branch_name
      FROM staff st
      JOIN branches b ON st.branch_id = b.id
      JOIN shops s ON b.shop_id = s.id
      WHERE st.id = ? AND s.admin_id = ?
    `,
      [staff_id, req.user.id]
    );

    if (!staffRows || staffRows.length === 0) {
      return res.status(403).json({ error: "Access denied or staff not found" });
    }

    let attendanceQuery = `
      SELECT *
      FROM attendance
      WHERE staff_id = ?
    `;

    const params = [staff_id];

    if (start_date) {
      attendanceQuery += " AND attendance_date >= ?";
      params.push(start_date);
    }

    if (end_date) {
      attendanceQuery += " AND attendance_date <= ?";
      params.push(end_date);
    }

    attendanceQuery += " ORDER BY attendance_date DESC";

    const attendance = await query(attendanceQuery, params);

    res.json({
      staff: staffRows[0],
      attendance,
    });
  } catch (error) {
    res.status(500).json({ error: "Internal server error" });
  }
}

module.exports = getStaffAttendance;

