const { query } = require("./shared");

async function markManualAttendance(req, res) {
  try {
    const { staff_id, branch_id, attendance_date, status, notes } = req.body;

    if (!staff_id || !branch_id || !attendance_date || !status) {
      return res.status(400).json({
        error: "Staff ID, branch ID, date, and status are required",
      });
    }

    const staffRows = await query(
      `
      SELECT st.id
      FROM staff st
      JOIN branches b ON st.branch_id = b.id
      JOIN shops s ON b.shop_id = s.id
      WHERE st.id = ? AND b.id = ? AND s.admin_id = ?
    `,
      [staff_id, branch_id, req.user.id]
    );

    if (!staffRows || staffRows.length === 0) {
      return res.status(403).json({ error: "Access denied or staff not found" });
    }

    const existing = await query(
      "SELECT id FROM attendance WHERE staff_id = ? AND attendance_date = ?",
      [staff_id, attendance_date]
    );

    if (existing.length > 0) {
      await query(
        "UPDATE attendance SET status = ?, notes = ? WHERE id = ?",
        [status, notes || null, existing[0].id]
      );

      res.json({ message: "Attendance updated successfully" });
    } else {
      await query(
        `INSERT INTO attendance 
         (staff_id, branch_id, attendance_date, status, notes) 
         VALUES (?, ?, ?, ?, ?)`,
        [staff_id, branch_id, attendance_date, status, notes || null]
      );

      res.status(201).json({ message: "Attendance marked successfully" });
    }
  } catch (error) {
    res.status(500).json({ error: "Internal server error" });
  }
}

module.exports = markManualAttendance;

