const AppError = require("../../../utils/appError");
const conn = require("../../../services/db");

async function logout(req, res, next) {
  const { access_token } = req?.headers;

  try {
    if (!access_token) {
      return res.status(200).json({
        status: "error",
        message: "Invalid authorization",
      });
    }

    // Delete only the specific session token from user_sessions table
    // This ensures other devices remain logged in
    const deleteSessionQuery = "DELETE FROM `user_sessions` WHERE token = ?";

    conn.query(deleteSessionQuery, [access_token], async function (err, result) {
      if (err) {
        const errorMessage =
          err?.message || "Something went wrong, Please try again";
        return next(new AppError(errorMessage, 500));
      }

      // Also handle backward compatibility - clear token from users table if it exists
      // This is for old sessions that might still be in users table
      const clearUserTokenQuery =
        "UPDATE `users` SET token = NULL, expires_at = NULL WHERE token = ?";

      conn.query(clearUserTokenQuery, [access_token], function (clearErr) {
        if (clearErr) {
          // Log error but don't fail the logout
          console.log("Error clearing old token from users table:", clearErr);
        }

        return res.status(200).json({
          status: "success",
          message: "Logged out successfully",
        });
      });
    });
  } catch (e) {
    console.log("Exception Error : Frontend User Logout ", e);
    return next(new AppError("Something went wrong, Please try again", 500));
  }
}

module.exports = logout;

