const AppError = require("../../../utils/appError");
const conn = require("../../../services/db");
const moment = require("moment");

async function userLogin(req, res, next) {
  const { email, profile_picture, access_token, provider } = req?.body;
  try {
    if (provider && email) {
      const tokenExpireDate = moment().add(1, "year").valueOf();

      // First, update user profile picture and get user ID
      const updateUserQuery =
        "UPDATE `users` SET profile_picture = ? WHERE `is_deleted` IS NULL AND email = ? AND provider = ?";

      conn.query(
        updateUserQuery,
        [profile_picture, email, provider],
        async function (err, result, fields) {
          console.log("error", result);
          if (err) {
            const errorMessage =
              err?.message ||
              "Something went wrong, Please try again";
            return next(new AppError(errorMessage, 500));
          } else if (result) {
            // Get user ID after update
            const getUserQuery = "SELECT id FROM `users` WHERE `is_deleted` IS NULL AND email = ? AND provider = ?";
            conn.query(
              getUserQuery,
              [email, provider],
              async function (getUserErr, getUserResult) {
                if (getUserErr || !getUserResult || getUserResult.length === 0) {
                  return next(new AppError("User not found", 500));
                }

                const userId = getUserResult[0].id;

                // Insert new session into user_sessions table (supports multiple devices)
                const insertSessionQuery =
                  "INSERT INTO `user_sessions` (`user_id`, `token`, `expires_at`) VALUES (?, ?, ?)";

                conn.query(
                  insertSessionQuery,
                  [userId, access_token, tokenExpireDate],
                  async function (sessionErr, sessionResult) {
                    if (sessionErr) {
                      const errorMessage =
                        sessionErr?.message ||
                        "Something went wrong, Please try again";
                      return next(new AppError(errorMessage, 500));
                    } else {
                      return res.status(200).json({
                        status: "success",
                        message: "login successfully.",
                      });
                    }
                  }
                );
              }
            );
          }
        }
      );
    } else {
      return res.status(200).json({
        status: "error",
        message:
          "Invalid parameters received to start new login session. Please try again.",
      });
    }
  } catch (e) {
    console.log("Exception Error : Frontend User Login ", e);
    return next(new AppError("Something went wrong, Please try again", 500));
  }
}

module.exports = userLogin;
