const AppError = require("../../../utils/appError");
const conn = require("../../../services/db");
const moment = require("moment");

async function verifyUserAccessToken(req, res, next) {
  const { access_token } = req?.headers;

  try {
    if (access_token) {
      // Check user_sessions table for multi-device support
      const query =
        "SELECT us.user_id, us.expires_at FROM `user_sessions` us " +
        "INNER JOIN `users` u ON us.user_id = u.id " +
        "WHERE u.`is_deleted` IS NULL AND us.token = ?";
      conn.query(query, [access_token], async function (err, result, fields) {
        if (err) {
          const errorMessage =
            err?.message || "Something went wrong, Please try again";
          return next(new AppError(errorMessage, 500));
        } else if (result) {
          const expires_at = (result.length > 0 && result[0]?.expires_at) ?? 0;
          var current_time = moment().valueOf();

          if (expires_at > current_time) {
            const userId = result[0]?.user_id;
            req.headers.user_id = userId;
            req.user = {
              id: userId,
              role: "admin",
            };
            return next();
          } else {
            res.status(200).json({
              status: "error",
              message: "User login session timed out",
            });
          }
        } else {
          // Token not found in user_sessions, check users table for backward compatibility
          const fallbackQuery =
            "SELECT id, expires_at FROM `users` WHERE `is_deleted` IS NULL AND token = ?";
          conn.query(fallbackQuery, [access_token], async function (fallbackErr, fallbackResult) {
            if (fallbackErr) {
              const errorMessage =
                fallbackErr?.message || "Something went wrong, Please try again";
              return next(new AppError(errorMessage, 500));
            } else if (fallbackResult && fallbackResult.length > 0) {
              const expires_at = fallbackResult[0]?.expires_at ?? 0;
              var current_time = moment().valueOf();

              if (expires_at > current_time) {
                const userId = fallbackResult[0]?.id;
                req.headers.user_id = userId;
                req.user = {
                  id: userId,
                  role: "admin",
                };
                return next();
              } else {
                res.status(200).json({
                  status: "error",
                  message: "User login session timed out",
                });
              }
            } else {
              // Token not found in either table
              res.status(200).json({
                status: "error",
                message: "Invalid authorization",
              });
            }
          });
        }
      });
    } else {
      res.status(200).json({
        status: "error",
        message: "Invalid authorization",
      });
    }
  } catch (e) {
    console.log("Exception Error : Frontend Authorization Middleware ", e);
    return next(new AppError("Something went wrong, Please try again", 500));
  }
}

module.exports = verifyUserAccessToken;
