const { query } = require("./shared");

async function createBranch(req, res) {
  try {
    const { shop_id, name, address, contact_phone } = req.body;

    if (!shop_id || !name) {
      return res.status(400).json({ error: 'Shop ID and branch name are required' });
    }

    // Verify shop belongs to this admin
    const shops = await query(
      'SELECT id FROM shops WHERE id = ? AND admin_id = ?',
      [shop_id, req.user.id]
    );

    if (!shops || shops.length === 0) {
      return res.status(403).json({ error: 'You do not have access to this shop' });
    }

    // Create branch
    const result = await query(
      'INSERT INTO branches (shop_id, name, address, contact_phone) VALUES (?, ?, ?, ?)',
      [shop_id, name, address || null, contact_phone || null]
    );

    res.status(201).json({
      message: 'Branch created successfully',
      branch: {
        id: result.insertId,
        shop_id,
        name,
        address,
        contact_phone
      }
    });

  } catch (error) {
    console.error('Create branch error:', error);
    res.status(500).json({ error: 'Internal server error' });
  }
}

module.exports = createBranch;

