const { query } = require("./shared");

async function deleteBranch(req, res) {
  try {
    const { id } = req.params;

    // Verify branch belongs to this admin
    const branches = await query(`
      SELECT b.id 
      FROM branches b
      JOIN shops s ON b.shop_id = s.id
      WHERE b.id = ? AND s.admin_id = ?
    `, [id, req.user.id]);

    if (!branches || branches.length === 0) {
      return res.status(403).json({ error: 'You do not have access to this branch' });
    }

    await query('DELETE FROM branches WHERE id = ?', [id]);

    res.json({ message: 'Branch deleted successfully' });

  } catch (error) {
    console.error('Delete branch error:', error);
    res.status(500).json({ error: 'Internal server error' });
  }
}

module.exports = deleteBranch;

