const { query } = require("./shared");

async function getBranchById(req, res) {
  try {
    const { id } = req.params;

    const branches = await query(`
      SELECT b.*, s.name as shop_name, s.admin_id
      FROM branches b
      JOIN shops s ON b.shop_id = s.id
      WHERE b.id = ?
    `, [id]);

    if (!branches || branches.length === 0) {
      return res.status(404).json({ error: 'Branch not found' });
    }

    const branch = branches[0];

    // Verify access
    if (branch.admin_id !== req.user.id) {
      return res.status(403).json({ error: 'You do not have access to this branch' });
    }

    res.json({ branch });

  } catch (error) {
    console.error('Get branch error:', error);
    res.status(500).json({ error: 'Internal server error' });
  }
}

module.exports = getBranchById;

