const { query } = require("./shared");

async function getBranchesByShop(req, res) {
  try {
    const { shop_id } = req.params;

    // Verify shop belongs to this admin
    const shops = await query(
      'SELECT id FROM shops WHERE id = ? AND admin_id = ?',
      [shop_id, req.user.id]
    );

    if (!shops || shops.length === 0) {
      return res.status(403).json({ error: 'You do not have access to this shop' });
    }

    // Get branches with staff count
    const branches = await query(`
      SELECT 
        b.*,
        COUNT(DISTINCT s.id) as staff_count
      FROM branches b
      LEFT JOIN staff s ON b.id = s.branch_id AND s.is_active = true
      WHERE b.shop_id = ? AND b.is_active = true
      GROUP BY b.id
      ORDER BY b.created_at DESC
    `, [shop_id]);

    res.json({ branches });

  } catch (error) {
    console.error('Get branches error:', error);
    res.status(500).json({ error: 'Internal server error' });
  }
}

module.exports = getBranchesByShop;

