const { query } = require("./shared");

async function updateBranch(req, res) {
  try {
    const { id } = req.params;
    const { name, address, contact_phone, is_active, has_admin_mode, admin_mode_password } = req.body;

    // Verify branch belongs to this admin
    const branches = await query(`
      SELECT b.id 
      FROM branches b
      JOIN shops s ON b.shop_id = s.id
      WHERE b.id = ? AND s.admin_id = ?
    `, [id, req.user.id]);

    if (!branches || branches.length === 0) {
      return res.status(403).json({ error: 'You do not have access to this branch' });
    }

    const updateFields = [];
    const values = [];

    if (name !== undefined) {
      updateFields.push('name = ?');
      values.push(name);
    }
    if (address !== undefined) {
      updateFields.push('address = ?');
      values.push(address);
    }
    if (contact_phone !== undefined) {
      updateFields.push('contact_phone = ?');
      values.push(contact_phone);
    }
    if (is_active !== undefined) {
      updateFields.push('is_active = ?');
      values.push(is_active);
    }

    // has_admin_mode is optional - only update if provided (independent of password)
    if (has_admin_mode !== undefined) {
      updateFields.push('has_admin_mode = ?');
      values.push(has_admin_mode);
    }
    
    // admin_mode_password is optional - only update if provided (independent of has_admin_mode)
    if (admin_mode_password !== undefined) {
      updateFields.push('admin_mode_password = ?');
      values.push(admin_mode_password);
    }
    if (updateFields.length === 0) {
      return res.status(400).json({ error: 'No fields to update' });
    }

    values.push(id);

    await query(
      `UPDATE branches SET ${updateFields.join(', ')} WHERE id = ?`,
      values
    );

    res.json({ message: 'Branch updated successfully' });

  } catch (error) {
    console.error('Update branch error:', error);
    res.status(500).json({ error: 'Internal server error' });
  }
}

module.exports = updateBranch;

