const { query } = require("./shared");

async function verifyBranchPin(req, res) {
  try {
    const { id } = req.params;
    const { pin } = req.body;

    if (!pin) {
      return res.status(400).json({ error: "PIN is required" });
    }

    const branches = await query("SELECT pin FROM branches WHERE id = ?", [id]);

    if (!branches || branches.length === 0) {
      return res.status(404).json({ error: "Branch not found" });
    }

    const branch = branches[0];

    // If branch has no PIN, allow access (current behavior)
    if (!branch.pin) {
      return res.json({ success: true, message: "No PIN set for this branch" });
    }

    if (branch.pin === pin) {
      return res.json({ success: true, message: "PIN verified" });
    }

    return res.status(401).json({ error: "Invalid PIN" });
  } catch (error) {
    console.error("Verify branch PIN error:", error);
    res.status(500).json({ error: "Internal server error" });
  }
}

module.exports = verifyBranchPin;


