const conn = require("../../services/db");
const { getConnectionHealth } = require("../../services/db");

async function healthCheck(req, res) {
  try {
    // Get connection health stats
    const health = getConnectionHealth();
    
    // Test the connection with a simple query
    const testQuery = "SELECT 1 as test";
    
    conn.query(testQuery, (err, results) => {
      if (err) {
        return res.status(503).json({
          status: "error",
          message: "Database connection failed",
          error: err.message,
          health: {
            ...health,
            status: "unhealthy",
            lastTest: new Date().toISOString()
          }
        });
      }
      
      // Connection is healthy
      res.status(200).json({
        status: "success",
        message: "Database connection is healthy",
        health: {
          ...health,
          status: "healthy",
          lastTest: new Date().toISOString(),
          testQueryResult: results[0]
        }
      });
    });
  } catch (error) {
    res.status(500).json({
      status: "error",
      message: "Health check failed",
      error: error.message
    });
  }
}

module.exports = healthCheck;

