const { v4: uuidv4 } = require("uuid");
const {
  query,
  ensureBranchAccess,
  formatBreakType,
} = require("./shared");

async function createBreakType(req, res) {
  try {
    const branchId = Number(req.body.branch_id || req.params.branch_id);
    const { name, duration_minutes: durationMinutes } = req.body;

    if (!branchId || !name || durationMinutes === undefined) {
      return res.status(400).json({
        error: "Branch, break name, and duration are required",
      });
    }

    if (Number(durationMinutes) <= 0) {
      return res
        .status(400)
        .json({ error: "Break duration must be greater than zero" });
    }

    await ensureBranchAccess(branchId, req.user.id);

    const id = uuidv4();
    await query(
      `
      INSERT INTO roster_break_types
        (id, branch_id, name, duration_minutes, created_by)
      VALUES (?, ?, ?, ?, ?)
    `,
      [id, branchId, name.trim(), durationMinutes, req.user.id]
    );

    const rows = await query("SELECT * FROM roster_break_types WHERE id = ?", [
      id,
    ]);

    res.status(201).json({ break_type: formatBreakType(rows[0]) });
  } catch (error) {
    console.error("Create break type error:", error);
    res.status(error.status || 500).json({
      error: error.message || "Failed to create break type",
    });
  }
}

module.exports = createBreakType;

