const { v4: uuidv4 } = require("uuid");
const { query, ensureBranchAccess, formatPosition } = require("./shared");

async function createPosition(req, res) {
  try {
    const branchId = Number(req.body.branch_id || req.params.branch_id);
    const { name } = req.body;

    if (!branchId || !name) {
      return res
        .status(400)
        .json({ error: "Branch and position name are required" });
    }

    await ensureBranchAccess(branchId, req.user.id);

    const id = uuidv4();
    await query(
      `
      INSERT INTO roster_positions
        (id, branch_id, name, created_by)
      VALUES (?, ?, ?, ?)
    `,
      [id, branchId, name.trim(), req.user.id]
    );

    const rows = await query("SELECT * FROM roster_positions WHERE id = ?", [
      id,
    ]);

    res.status(201).json({ position: formatPosition(rows[0]) });
  } catch (error) {
    console.error("Create position error:", error);
    res.status(error.status || 500).json({
      error: error.message || "Failed to create position",
    });
  }
}

module.exports = createPosition;

