const { v4: uuidv4 } = require("uuid");
const {
  query,
  ensureBranchAccess,
  formatShiftType,
} = require("./shared");

async function createShiftType(req, res) {
  try {
    const branchId = Number(req.body.branch_id || req.params.branch_id);
    const { name, start_minutes: startMinutes, end_minutes: endMinutes } = req.body;

    if (
      !branchId ||
      !name ||
      startMinutes === undefined ||
      endMinutes === undefined
    ) {
      return res.status(400).json({ error: "Name and time range are required" });
    }

    if (Number(startMinutes) >= Number(endMinutes)) {
      return res
        .status(400)
        .json({ error: "End time must be later than start time" });
    }

    await ensureBranchAccess(branchId, req.user.id);

    const id = uuidv4();
    await query(
      `
      INSERT INTO roster_shift_types
      (id, branch_id, name, start_minutes, end_minutes, created_by)
      VALUES (?, ?, ?, ?, ?, ?)
    `,
      [id, branchId, name.trim(), startMinutes, endMinutes, req.user.id]
    );

    const rows = await query("SELECT * FROM roster_shift_types WHERE id = ?", [
      id,
    ]);

    res.status(201).json({ shift_type: formatShiftType(rows[0]) });
  } catch (error) {
    console.error("Create shift type error:", error);
    res.status(error.status || 500).json({
      error: error.message || "Failed to create shift type",
    });
  }
}

module.exports = createShiftType;

