const { query, ensureRosterEntityAccess } = require("./shared");

async function deleteBreakType(req, res) {
  try {
    const { id } = req.params;
    await ensureRosterEntityAccess("roster_break_types", id, req.user.id);
    await query("DELETE FROM roster_break_types WHERE id = ?", [id]);
    res.json({ message: "Break type deleted" });
  } catch (error) {
    console.error("Delete break type error:", error);
    res.status(error.status || 500).json({
      error: error.message || "Failed to delete break type",
    });
  }
}

module.exports = deleteBreakType;

