const { query, ensureRosterEntityAccess } = require("./shared");

async function deletePosition(req, res) {
  try {
    const { id } = req.params;
    await ensureRosterEntityAccess("roster_positions", id, req.user.id);
    await query("DELETE FROM roster_positions WHERE id = ?", [id]);
    res.json({ message: "Position deleted" });
  } catch (error) {
    console.error("Delete position error:", error);
    res.status(error.status || 500).json({
      error: error.message || "Failed to delete position",
    });
  }
}

module.exports = deletePosition;

