const { query, ensureRosterEntityAccess } = require("./shared");

async function deleteShiftType(req, res) {
  try {
    const { id } = req.params;
    await ensureRosterEntityAccess("roster_shift_types", id, req.user.id);
    await query("DELETE FROM roster_shift_types WHERE id = ?", [id]);
    res.json({ message: "Shift type deleted" });
  } catch (error) {
    console.error("Delete shift type error:", error);
    res.status(error.status || 500).json({
      error: error.message || "Failed to delete shift type",
    });
  }
}

module.exports = deleteShiftType;

