const {
  query,
  ensureBranchAccess,
  formatShiftType,
  formatPosition,
  formatBreakType,
} = require("./shared");

async function getConfig(req, res) {
  try {
    const branchId = Number(req.params.branch_id);
    if (Number.isNaN(branchId)) {
      return res.status(400).json({ error: "Invalid branch ID" });
    }

    const branch = await ensureBranchAccess(branchId, req.user.id);

    const shiftTypes = await query(
      "SELECT * FROM roster_shift_types WHERE branch_id = ? ORDER BY start_minutes ASC",
      [branchId]
    );
    const positions = await query(
      "SELECT * FROM roster_positions WHERE branch_id = ? ORDER BY name ASC",
      [branchId]
    );
    const breakTypes = await query(
      "SELECT * FROM roster_break_types WHERE branch_id = ? ORDER BY duration_minutes ASC",
      [branchId]
    );

    res.json({
      branch: {
        id: branch.id,
        name: branch.name,
        shop_id: branch.shop_id,
        shop_name: branch.shop_name,
      },
      shift_types: shiftTypes.map(formatShiftType),
      positions: positions.map(formatPosition),
      break_types: breakTypes.map(formatBreakType),
    });
  } catch (error) {
    console.error("Get roster config error:", error);
    res.status(error.status || 500).json({
      error: error.message || "Failed to fetch roster configuration",
    });
  }
}

module.exports = getConfig;

