const {
  query,
  ensureRosterEntityAccess,
  formatBreakType,
} = require("./shared");

async function updateBreakType(req, res) {
  try {
    const { id } = req.params;
    const { name, duration_minutes: durationMinutes } = req.body;

    await ensureRosterEntityAccess("roster_break_types", id, req.user.id);

    const updateFields = [];
    const values = [];

    if (name !== undefined) {
      const trimmed = name.trim();
      if (!trimmed) {
        return res.status(400).json({ error: "Break name cannot be empty" });
      }
      updateFields.push("name = ?");
      values.push(trimmed);
    }

    if (durationMinutes !== undefined) {
      if (Number(durationMinutes) <= 0) {
        return res
          .status(400)
          .json({ error: "Break duration must be greater than zero" });
      }
      updateFields.push("duration_minutes = ?");
      values.push(durationMinutes);
    }

    if (updateFields.length === 0) {
      return res.status(400).json({ error: "No fields to update" });
    }

    values.push(id);

    await query(
      `UPDATE roster_break_types SET ${updateFields.join(", ")} WHERE id = ?`,
      values
    );

    const rows = await query("SELECT * FROM roster_break_types WHERE id = ?", [
      id,
    ]);

    res.json({ break_type: formatBreakType(rows[0]) });
  } catch (error) {
    console.error("Update break type error:", error);
    res.status(error.status || 500).json({
      error: error.message || "Failed to update break type",
    });
  }
}

module.exports = updateBreakType;

