const {
  query,
  ensureRosterEntityAccess,
  formatShiftType,
} = require("./shared");

async function updateShiftType(req, res) {
  try {
    const { id } = req.params;
    const { name, start_minutes: startMinutes, end_minutes: endMinutes } = req.body;

    const existing = await ensureRosterEntityAccess(
      "roster_shift_types",
      id,
      req.user.id
    );

    const updateFields = [];
    const values = [];

    if (name !== undefined) {
      updateFields.push("name = ?");
      values.push(name.trim());
    }

    if (startMinutes !== undefined) {
      updateFields.push("start_minutes = ?");
      values.push(startMinutes);
    }

    if (endMinutes !== undefined) {
      updateFields.push("end_minutes = ?");
      values.push(endMinutes);
    }

    if (updateFields.length === 0) {
      return res.status(400).json({ error: "No fields to update" });
    }

    if (
      (startMinutes !== undefined || endMinutes !== undefined) &&
      Number(startMinutes !== undefined ? startMinutes : existing.start_minutes) >=
        Number(endMinutes !== undefined ? endMinutes : existing.end_minutes)
    ) {
      return res
        .status(400)
        .json({ error: "End time must be later than start time" });
    }

    values.push(id);

    await query(
      `UPDATE roster_shift_types SET ${updateFields.join(", ")} WHERE id = ?`,
      values
    );

    const rows = await query("SELECT * FROM roster_shift_types WHERE id = ?", [
      id,
    ]);

    res.json({ shift_type: formatShiftType(rows[0]) });
  } catch (error) {
    console.error("Update shift type error:", error);
    res.status(error.status || 500).json({
      error: error.message || "Failed to update shift type",
    });
  }
}

module.exports = updateShiftType;

