const AppError = require("../../../utils/appError");

async function search(req, res, next) {
  try {
    if (!req?.body) return next(new AppError("No req data found", 404));
    const { search } = req?.body;

    res.status(200).json({
      status: "success",
      message: "Search Result",
      data: [],
    });
  } catch (e) {
    console.log("Exception Error : Search Failed ", e);
    return next(new AppError("Something went wrong, Please try again", 500));
  }
}

module.exports = search;
