const {
  query,
  ensureStaffAccess,
} = require("./shared");

async function deleteStaff(req, res) {
  try {
    const { id } = req.params;

    await ensureStaffAccess(id, req.user.id);

    await query("DELETE FROM staff WHERE id = ?", [id]);

    res.json({ message: "Staff deleted successfully" });
  } catch (error) {
    console.error("Delete staff error:", error);
    res.status(error.status || 500).json({ error: error.message || "Internal server error" });
  }
}

module.exports = deleteStaff;

