const {
  query,
  ensureStaffAccess,
} = require("./shared");

async function updateFaceEmbeddings(req, res) {
  try {
    const { id } = req.params;
    const { face_embedding: faceEmbedding } = req.body;

    if (!faceEmbedding || typeof faceEmbedding !== "string") {
      return res
        .status(400)
        .json({ error: "face_embedding (base64 string) is required" });
    }

    await ensureStaffAccess(id, req.user.id);

    await query(
      'UPDATE staff SET face_embeddings = JSON_OBJECT("image", ?) WHERE id = ?',
      [faceEmbedding, id]
    );

    res.json({ message: "Face embedding updated successfully" });
  } catch (error) {
    console.error("Update face embeddings error:", error);
    res.status(error.status || 500).json({ error: error.message || "Internal server error" });
  }
}

module.exports = updateFaceEmbeddings;

