const {
  query,
  ensureStaffAccess,
  normalizeRole,
} = require("./shared");
const encryptionService = require("../../../services/encryptionService");

async function updateStaff(req, res) {
  try {
    const { id } = req.params;
    const {
      full_name: fullName,
      email,
      phone,
      position,
      is_active: isActive,
      hourly_rate: hourlyRate,
      profile_image_path: profileImagePath,
    } = req.body;

    await ensureStaffAccess(id, req.user.id);

    const updateFields = [];
    const values = [];

    if (fullName !== undefined) {
      updateFields.push("full_name = ?");
      values.push(encryptionService.encrypt(fullName));
    }
    if (email !== undefined) {
      updateFields.push("email = ?");
      values.push(email ? encryptionService.encrypt(email) : null);
    }
    if (phone !== undefined) {
      updateFields.push("phone = ?");
      values.push(phone ? encryptionService.encrypt(phone) : null);
    }
    if (position !== undefined) {
      updateFields.push("position = ?");
      values.push(normalizeRole(position));
    }
    if (isActive !== undefined) {
      updateFields.push("is_active = ?");
      values.push(isActive);
    }
    if (hourlyRate !== undefined) {
      updateFields.push("hourly_rate = ?");
      values.push(hourlyRate);
    }
    if (profileImagePath !== undefined) {
      updateFields.push("profile_image_path = ?");
      values.push(profileImagePath);
    }

    if (updateFields.length === 0) {
      return res.status(400).json({ error: "No fields to update" });
    }

    values.push(id);

    await query(
      `UPDATE staff SET ${updateFields.join(", ")} WHERE id = ?`,
      values
    );

    res.json({ message: "Staff updated successfully" });
  } catch (error) {
    console.error("Update staff error:", error);
    res.status(error.status || 500).json({ error: error.message || "Internal server error" });
  }
}

module.exports = updateStaff;

