const util = require("util");
// Path from controllers/frontend/staffAuth -> services/db
const conn = require("../../../services/db");

// Promise-based query helper
const query = util.promisify(conn.query).bind(conn);

// Compatibility wrapper to mimic mysql2/promise structure ([rows])
const dbCompat = {
  query: async (...args) => {
    const rows = await query(...args);
    return [rows];
  },
};

module.exports = {
  query,
  dbCompat,
  conn,
};


