const jwt = require("jsonwebtoken");

const generateToken = (user) => {
  const payload = {
    id: user.id,
    email: user.email,
    role: user.role,
    full_name: user.full_name,
  };

  ["staff_id", "branch_id", "shop_id", "admin_id", "phone"].forEach((key) => {
    if (user[key] !== undefined) {
      payload[key] = user[key];
    }
  });

  return jwt.sign(payload, process.env.JWT_SECRET, {
    expiresIn: process.env.JWT_EXPIRES_IN || "7d",
  });
};

const generateRefreshToken = (user) => {
  const payload = {
    id: user.id,
    email: user.email,
    role: user.role,
  };

  return jwt.sign(
    payload,
    process.env.JWT_REFRESH_SECRET || process.env.JWT_SECRET + "_refresh",
    { expiresIn: process.env.JWT_REFRESH_EXPIRES_IN || "30d" },
  );
};

module.exports = {
  generateToken,
  generateRefreshToken,
};


