const AppError = require("../../../utils/appError");
const { conn } = require("./shared");

async function verifyEmail(req, res, next) {
  let token = req?.query?.token || req?.body?.token;

  if (token) {
    token = token.trim();
    try {
      token = decodeURIComponent(token);
    } catch (e) {
      console.log("Token decode warning:", e.message);
    }
  }

  try {
    if (!token) {
      return res.status(400).json({
        status: "error",
        message: "Verification token is required",
      });
    }

    const query =
      "SELECT id, email, email_verified, verification_token_expiry FROM `users` WHERE `is_deleted` IS NULL AND verification_token = ?";

    conn.query(query, [token], async function (err, result) {
      if (err) {
        return next(
          new AppError(err?.message || "Something went wrong, Please try again", 500),
        );
      }

      if (!result || result.length === 0) {
        return res.status(200).json({
          status: "success",
          message: "Email already verified. You can now log in.",
        });
      }

      const user = result[0];
      const emailVerifiedValue = Number(user.email_verified);
      const isVerified = emailVerifiedValue === 1;

      if (isVerified) {
        return res.status(200).json({
          status: "success",
          message: "Email already verified. You can now log in.",
        });
      }

      const now = new Date();
      const expiryDate = new Date(user.verification_token_expiry);
      if (expiryDate < now) {
        return res.status(400).json({
          status: "error",
          message:
            "Verification token has expired. Please request a new verification email.",
        });
      }

      const updateQuery =
        "UPDATE `users` SET email_verified = 1, verification_token = NULL, verification_token_expiry = NULL WHERE id = ? AND verification_token = ?";

      conn.query(
        updateQuery,
        [user.id, token],
        function (updateErr, updateResult) {
          if (updateErr) {
            return next(
              new AppError(
                updateErr?.message || "Something went wrong, Please try again",
                500,
              ),
            );
          }

          if (updateResult && updateResult.affectedRows > 0) {
            return res.status(200).json({
              status: "success",
              message: "Your email address was verified successfully.",
            });
          }

          const checkQuery = "SELECT email_verified FROM `users` WHERE id = ?";
          conn.query(checkQuery, [user.id], function (checkErr, checkResult) {
            if (!checkErr && checkResult && checkResult.length > 0) {
              if (checkResult[0].email_verified === 1) {
                return res.status(200).json({
                  status: "success",
                  message: "Email is verified. You can now log in.",
                });
              }
            }
            return res.status(400).json({
              status: "error",
              message:
                "Verification failed. Please try again or contact support.",
            });
          });
        },
      );
    });
  } catch (e) {
    console.log("Exception Error : Email Verification ", e);
    return next(new AppError("Something went wrong, Please try again", 500));
  }
}

module.exports = verifyEmail;


