const DbHelper = require("../../../helpers/DbHelper");
const AppError = require("../../../utils/appError");
const conn = require("../../../services/db");

async function getActiveSubscriptionPlans(req, res, next) {
  try {
    const query =
      "SELECT id, name, price, duration_type, max_locations, max_staff, description, status FROM `subscription_plans` WHERE `is_deleted` IS NULL AND `status` = 'active' ORDER BY price ASC";

    const result = await DbHelper.promisifyQuery(query, conn, next);

    // Convert price from string to number (MySQL DECIMAL returns as string)
    const plans = (result || []).map(plan => ({
      ...plan,
      price: parseFloat(plan.price) || 0,
    }));

    res.status(200).json({
      status: "success",
      message: "Active subscription plans fetched successfully",
      data: plans,
    });
  } catch (e) {
    console.log("Exception Error : Get Active Subscription Plans ", e);
    return next(new AppError("Something went wrong, Please try again", 500));
  }
}

module.exports = getActiveSubscriptionPlans;

