const AppError = require("../../../utils/appError");
const conn = require("../../../services/db");
const DbHelper = require("../../../helpers/DbHelper");

async function UserInfo(req, res, next) {
  try {
    const { user_id } = req?.headers;

    const userDetail = await DbHelper.promisifyQuery(
      `SELECT uns.*, u.*
      FROM users as u 
      LEFT JOIN user_notification_settings as uns ON uns.user_id = u.id
      WHERE u.id = ${user_id}`,
      conn,
      next
    );

    if (userDetail.length < 1) {
      return next(
        new AppError(
          "Please try to re-login again, requested information not found.",
          401
        )
      );
    }

    res.status(200).json({
      status: "success",
      message: "User information.",
      data: {
        ...userDetail[0],
      },
    });
  } catch (e) {
    console.log("Exception Error : User Info api failure details ", e);
    return next(new AppError("Something went wrong, Please try again", 500));
  }
}

module.exports = UserInfo;
