const getEnvConfig = require("../utils/Config");
const jwt = require("jsonwebtoken");

const PRIVATE_KEY = getEnvConfig("PRIVATE_KEY");
const REFRESH_PRIVATE_KEY = getEnvConfig("REFRESH_PRIVATE_KEY");
module.exports = {
  getAccessToken: (payload) =>
    jwt.sign(payload, PRIVATE_KEY, {
      expiresIn: 60 * 60 * 24 * 1,
    }),
  getRefreshToken: (payload) =>
    jwt.sign(payload, REFRESH_PRIVATE_KEY, {
      expiresIn: 60 * 60 * 24 * 30,
    }),
  verifyAccessToken: (req) => {
    try {
      const headers = req?.headers;
      if (headers?.["x-auth-token"]) {
        return jwt.verify(headers["x-auth-token"], PRIVATE_KEY);
      }
      return false;
    } catch (e) {
      console.log("Exception found to validate token ", e);
      return false;
    }
  },
};
