const fs = require("fs");
const AWS = require("aws-sdk");

// import { getTimeStamp } from "./Date";
const cloudinary = require("cloudinary").v2;

const base64ToFile = async (file, dir) => {
  try {
    return await uploadToServer(file, dir);
  } catch (e) {
    errorLog(
      "Exception found in cloudinary server file upload please check the error as follow :" +
        JSON.stringify(e)
    );
    return { path: "" };
  }
};

const uploadToServer = async (base64, dir) => {
  return await uploadOnS3(base64, dir);
};

const uploadOnS3 = async (base64, dir) => {
  const s3 = new AWS.S3({
    accessKeyId: process.env.AWS_ACCESS_KEY,
    secretAccessKey: process.env.AWS_SECRET_KEY,
  });

  const base64Data = new Buffer.from(
    base64.replace(/^data:image\/\w+;base64,/, ""),
    "base64"
  );
  const type = base64.split(";")[0].split("/")[1];
  const randomFileName = getRandomFileName();

  const params = {
    Bucket: "contest-app-bucket",
    Key: `${randomFileName}.${type}`, // type is not required
    Body: base64Data,
    // ACL: "public-read",
    ContentEncoding: "base64", // required
    ContentType: `image/${type}`, // required. Notice the back ticks
  };

  let location = "";
  let key = "";
  try {
    const { Location, Key } = await s3.upload(params).promise();
    location = Location;
    key = Key;
  } catch (error) {
    console.log("error to upload file ", error);
  }
  return { path: location, id: key };
};

const uploadOnCloudinary = async (base64, dir) => {
  //https://cloudinary.com/documentation/node_integration#landingpage
  // Configuration
  cloudinary.config({
    cloud_name: process.env.CLOUDINARY_NAME,
    api_key: process.env.CLOUDINARY_API_KEY,
    api_secret: process.env.CLOUDINARY_SECRET,
    secure: true,
  });
  // Upload

  // Use the uploaded file's name as the asset's public ID and
  //https://cloudinary.com/documentation/image_upload_api_reference#upload_optional_parameters
  // allow overwriting the asset with new versions
  const options = {
    use_filename: true,
    unique_filename: false,
    overwrite: true,
    folder: `contestApp/contest/${dir}`,
  };

  const res = cloudinary.uploader.upload(base64, options);

  let resourceUrl = "";
  let publicId = "";

  await res
    .then((data) => {
      resourceUrl = data.secure_url;
      publicId = data?.public_id;
    })
    .catch((err) => {
      console.log(err);
    });

  // // Generate
  // const url = cloudinary.url(publicId, {
  //     width: 100,
  //     height: 150,
  //     Crop: "fill",
  // });

  // The output url
  // console.log("final output ", resourceUrl);
  return { path: resourceUrl, id: publicId };
};

// const localFileUploading = async (file, dir) => {
//     const fileType = getFileType(file);
//     const fileExtension = getExtension(fileType);
//     let fileContents = "";
//     let imageFileName = `-${dir}.${fileExtension}`;
//     try {
//         fileContents = Buffer.from(file.split(",")[1], "base64");

//         fs.mkdirSync(`./public/uploads/${dir}`, { recursive: true });

//         const fileName = `./public/uploads/${dir}/${
//             getTimeStamp() + imageFileName
//         }`;

//         return await writeFile(fileName, fileContents).then((err) => {
//             if (err) {
//                 errorLog(
//                     "IMAGE UPLOAD Found some issue to upload the image in directory please refer the below error " +
//                         `${JSON.stringify(err)}`
//                 );
//                 return {
//                     success: false,
//                     message:
//                         JSON.stringify(err) ||
//                         "Unable to upload the file, Please try again.",
//                 };
//             } else {
//                 infoLog(
//                     "FILE UPLOAD Successfully " + fileType + " " + fileName
//                 );
//                 return {
//                     success: true,
//                     path: fileName,
//                 };
//             }
//         });
//     } catch (e) {
//         errorLog(`IMAGE UPLOAD Exception found , ${JSON.stringify(e)}`);
//         return {
//             success: false,
//             message:
//                 e?.message || "Unable to upload the file, Please try again.",
//         };
//     }
// };

const getFileType = (base64) => {
  if (base64) {
    return base64.split(":")[1].split(";")[0];
  }
  return null;
};

const getExtension = (fileType) => {
  return fileType.split("/")[1];
};

const writeFile = (path, data, opts = "utf8") =>
  new Promise((resolve, reject) => {
    fs.writeFile(path, data, opts, (err) => {
      if (err) reject(err);
      else resolve();
    });
  });

function getRandomFileName() {
  const timestamp = new Date().toISOString().replace(/[-:.]/g, "");
  const random = ("" + Math.random()).substring(2, 8);
  const random_number = timestamp + random;
  return random_number;
}

module.exports = {
  base64ToFile,
  uploadToServer,
};
