const { verifyAccessToken } = require("../helpers/JwtHelper");

module.exports = {
    Guest: (req, res, next) => {
        next();
    },
    Authorize: (req, res, next) => {
        const isValidAccessToken = verifyAccessToken(req);
        if (!isValidAccessToken) {
            res.status(200).json({
                status: "error",
                message: "Unauthenticated Request",
            });
            return;
        }
        next();
    },
};
