const DbHelper = require("../../helpers/DbHelper");
const AppError = require("../../utils/appError");
const conn = require("../../services/db");

async function isUserRegistered(req, res, next) {
  const { user_id } = req?.headers;
  if (!user_id) {
    return res.status(200).json({
      status: "error",
      message: "Invalid request to process",
    });
  }

  try {
    const isExistUser = await DbHelper.promisifyQuery(
      `SELECT id FROM \`users\` WHERE id = "${user_id}" AND is_deleted IS NULL`,
      conn,
      next
    );

    if (isExistUser?.length < 1) {
      res.status(200).json({
        status: "error",
        message:
          "Please Logout from this current account and try to login back. System encountered some technical problems",
      });
    } else {
      return next();
    }
  } catch (e) {
    console.log("Exception Error : Contest Creation ", e);
    return next(new AppError("Something went wrong, Please try again", 500));
  }
}

module.exports = isUserRegistered;
